import { View, Text, FlatList, StyleSheet } from "react-native";
import React from "react";
import ClockIcon from "../../../assets/svgs/filter/clock.svg";
import { filterHomeStyle } from "./FilterHomeStyle";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";
import { useEffect } from "react";
import useAuth from "../../../hooks/useAuth";
import { useState } from "react";
import RecentSearchSkeleton from "../../../src/skeletons/screens/Search/RecentSearchSkeleton";
import { query } from "../../../redux/slices/util/apiRequest";
import { BASE_API_URL_STG } from "@env";
import useLangTranslation from "../../../hooks/useLangTranslation";
import CustomSVG from "../../../src/components/CustomSVG/CustomSVG";

const URL = `${BASE_API_URL_STG}/user/recent-search`;
const clockIconSize = dpr(12);

const RecentSearch = ({ handleSearch }) => {
    const [recentData, setRecentData] = useState([]);
    const [loading, setLoading] = useState(true);
    const { access_token } = useAuth();
    const { trans } = useLangTranslation();

    useEffect(() => {
        (async () => {
            try {
                const data = await query(URL, "GET", access_token);
                const { status: { code } = {}, records } = data?.response;
                if (code === 200) {
                    setRecentData(records?.data);
                }
            } catch (error) {
            } finally {
                setLoading(false);
            }
        })()
    }, []);

    const handleRecentSearch = (text) => {
        handleSearch(text);
    };

    return (
        <FlatList
            showsVerticalScrollIndicator={false}
            ListHeaderComponent={() => (
                <>
                    {access_token && (
                        <View>
                            <View style={filterHomeStyle.headerCont}>
                                <Text style={filterHomeStyle.header}>
                                    {trans("Recent Search")}
                                </Text>
                            </View>
                            {loading ? (
                                <RecentSearchSkeleton />
                            ) : (
                                <View style={styles.mt}>
                                    {recentData?.length > 0 ? (
                                        recentData
                                            .slice(-5)
                                            .reverse()
                                            .map((item, i) => (
                                                <View
                                                    key={`key-${i}`}
                                                    style={
                                                        filterHomeStyle.historyCont
                                                    }
                                                >
                                                    <CustomSVG svgIcon={ClockIcon}
                                                        height={clockIconSize}
                                                        width={clockIconSize}
                                                    />
                                                    <Text
                                                        style={
                                                            filterHomeStyle.historyText
                                                        }
                                                        onPress={() =>
                                                            handleRecentSearch(
                                                                item?.name
                                                            )
                                                        }
                                                    >
                                                        {item?.name}
                                                    </Text>
                                                </View>
                                            ))
                                    ) : (
                                        <View>
                                            <Text>
                                                {trans("You haven't search anything yet.")}
                                            </Text>
                                        </View>
                                    )}
                                </View>
                            )}
                        </View>
                    )}
                </>
            )}
        />
    );
};

export default RecentSearch;

const styles = StyleSheet.create({
    marginTop: dpr(10),
});
